
@extends('front.layouts.master')
@section('content')



   <main>
 
        <!-- slider Area Start-->
        <div class="slider-area ">
            <div class="single-slider hero-overly slider-height2 d-flex align-items-center"




      @if(($page->icon==null)) data-background="{{ asset('front_assets/assets/img/hero/about.jpg') }}"
      @else   data-background="/storage/{{ $page->icon }}" @endif>
             
             
             

                <div class="container">
                    <div class="row">
                        <div class="col-lg-10 col-xl-8">
                            <div class="hero-cap hero-cap2 pt-120">
                            <a href="{{ route('page.slug',$page->slug) }}"> <h2>{{ $page->name }}</h2></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>


     @if($page->name !=="Gallery")
     @if($page->name !=="Blog")
        <!-- slider Area End-->
        <!-- Services Details Start -->
        <div class="services-details-area">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <div class="single-services section-padding2">
                            <div class="details-img mb-40">
                                <img src="/storage/{{ $page->banner }}" alt="">
                            </div>
                            <div class="details-caption">
                    <p>{{ $page->short_description }}</p>
                               <p>{!! $page->description !!}</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        @endif
@endif
        @php
$sub_child_pages=App\Models\Page::where('parent_id',$page->id)->where('status',1)->orderby('weight','asc')->get();
 

@endphp

@if(isset($sub_child_pages))
@if($sub_child_pages->count() > 0)

        <div class="services-area1 section-padding30">
            <div class="container">
                <!-- section tittle -->
                <div class="row">
                    <div class="col-lg-12">
                        <div class="section-tittle mb-55">
                            <div class="front-text">
                                <h2 class="">{{ $page->name }}</h2>
                            </div>
                            <span class="back-text">{{ $page->name }}</span>
                        </div>
                    </div>
                </div>
                <div class="row">
                @foreach($sub_child_pages as $sub_child_page) 
                    <div class="col-xl-4 col-lg-4 col-md-6">
                        <div class="single-service-cap mb-30">
                            <div class="service-img">
                                <img src="/storage/{{ $sub_child_page->banner }}" alt="">
                            </div>
                            <div class="service-cap">
                                <h4><a href="{{ route('subchild.page',$sub_child_page->slug) }}">{{ $sub_child_page->name }}</a></h4>
                                <p>{{ $sub_child_page->short_description }}</p>
                                <a href="{{ route('subchild.page',$sub_child_page->slug) }}" class="more-btn">Read More <i class="ti-plus"></i></a>
                            </div>
                            <div class="service-icon">
                                <img src="{{ asset('front_assets/assets/img/icon/services_icon1.png') }}" alt="">
                            </div>
                        </div>
                    </div>
                 @endforeach
               
                </div>
            </div>
        </div>

@endif
@endif



     @if($page->name=="Gallery")

     @php

$medias=App\Models\Media::where('status',1)->where('gallery_type','image')->orderBy('weight','asc')->get();
@endphp


          <div class="section-top-border">
          
  @if(isset($medias))
            <div class="container">
                <h3>Image Gallery</h3>
                <div class="row gallery-item">

                @foreach($medias as $media)
                    <div class="col-md-4">
                        <a href="/storage/{{ $media->image }}" class="img-pop-up">
                            <div class="single-gallery-image" style="background:url(/storage/{{ $media->image }});"></div>
                        </a>
                    </div>
                    @endforeach
    

                </div>
                </div>
            </div>

            @endif
            </div>
            
@endif


@if($page->name=="Blog")
@php

$blogs=App\Models\Blog::where('status',1)->OrderBy('weight','asc')->simplePaginate(3);

@endphp
<section class="blog_area section-padding">
        <div class="container">
            <div class="row">
                <div class="col-lg-8 mb-5 mb-lg-0">
                    <div class="blog_left_sidebar">

                @foreach($blogs as $blog)                    
                        <article class="blog_item">
                            <div class="blog_item_img">
                                <img class="card-img rounded-0" src="/storage/{{ $blog->image }}" alt="">
                                <a href="#" class="blog_item_date">
                                    <h3>{{ $blog->updated_at->diffForHumans()  }}</h3>
                                   
                                </a>
                            </div>

                            <div class="blog_details">
                                <a class="d-inline-block" href="{{ route('blog.detail',$blog->slug) }}">
                                    <h2>{{ $blog->heading }}</h2>
                                </a>
                                <p>{{ $blog->short_description }}</p>
                                <ul class="blog-info-link">
    <li><a href="#"><i class="fa fa-user"></i>Published by:{{ $blog->published_by }}</a></li>


                                    <li><a href="#"><i class="fa fa-comments"></i> 03 Comments</a></li>
                                </ul>
                            </div>
                        </article>
                                     @endforeach
                   
                                     {{ $blogs->appends(['search' => request()->query('search')]) ->links() }}

                      
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="blog_right_sidebar">

                        <aside class="single_sidebar_widget search_widget">
                            <form action="{{ url('/search') }}" method="GET">
                                <div class="form-group">
                                    <div class="input-group mb-3">
                                        <input type="text" class="form-control" placeholder='Search Keyword'
                                            onfocus="this.placeholder = ''"
                                            onblur="this.placeholder = 'Search Keyword'" name="search">
                                        <div class="input-group-append">
                                            <button class="btns" type="submit"><i class="ti-search"></i></button>
                                        </div>
                                    </div>
                                </div>
                                <button class="button rounded-0 primary-bg text-white w-100 btn_1 boxed-btn"
                                    type="submit">Search</button>
                            </form>
                        </aside>
@php

$categories=App\Models\Category::all();

@endphp
                        <aside class="single_sidebar_widget post_category_widget">
                            <h4 class="widget_title">Category</h4>
                            <ul class="list cat-list">
                            @foreach($categories as $category)
                            
                                <li>
                                    <a href="{{ route('category.slug',$category->id) }}" class="d-flex">
                                        <p>{{ $category->name }}</p>
                                        <p>({{ $category->blogs()->count() }})</p>
                                    </a>
                                </li>
                                @endforeach
                               

                            </ul>
                        </aside>
                        @php
                        $tags=App\Models\Tag::all();

     $popular_blogs=App\Models\Blog::where('blog_type','popular')->where([['status',1]])->OrderBy('weight','asc')->take(4)->get();
        @endphp
                        <aside class="single_sidebar_widget popular_post_widget">
                            <h3 class="widget_title">Popular Post</h3>
                            @foreach($popular_blogs as $popular_blog)
                            <div class="media post_item">
                            <a href="{{ route('blog.detail',$popular_blog->slug) }}"><img src="/storage/{{ $popular_blog->image }}" alt="post" height="50px" width="50px"></a>
                                <div class="media-body">
                                    <a href="{{ route('blog.detail',$popular_blog->slug) }}">
                                        <h3>{{ $popular_blog->heading }}</h3>
                                    </a>
                                    <p>{{ $popular_blog->updated_at }}</p>
                                </div>
                            </div>
                            @endforeach

                           
                        </aside>

                        <aside class="single_sidebar_widget tag_cloud_widget">
                            <h4 class="widget_title">Tag</h4>
                            <ul class="list">
                            @foreach($tags as $tag)
                              
                                <li>
                                    <a href="{{ route('tags.group',$tag->id) }}">{{ $tag->name }}</a>
                                </li>
                               @endforeach


                            </ul>
                        </aside>


                       

                    </div>
                </div>
            </div>
        </div>
    </section>

@endif



    </main>
@endsection
